<?php
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../template/stile.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/Contenuto.php";
    include "../classi/Immagine.php";
    include "../classi/FileScaricabile.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $contenuto = new Contenuto($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $contenuto = new Contenuto($geecomDb, filter_input(INPUT_POST, "id"));
    }
    
    // dato che serve in molti switch per generare il link a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomCMS  = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'creaArticolo':
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            
            $contenuto->setContenutoRiferimento(0);
            $contenuto->setMostraTitolo("si");
            $contenuto->setLingua("italiano");
            $contenuto->setTipo("articolo");
            $contenuto->setMostraNellaHome("si");
            $contenuto->setCommenti("si");
            $contenuto->setStato("bozza");
            $contenuto->setPunteggioSeo("scadente");
            $contenuto->setTemplate("articolo.php");
            $contenuto->setAttivaBreadcrumbs("si");
            $contenuto->setPosizione(0);
            $contenuto->setCategoria(0);
            $contenuto->setAutore(filter_var($_SESSION["geecomAdmin_nomeCognome"],FILTER_SANITIZE_ADD_SLASHES));
            $id = $contenuto->crea();
            
            $query = "UPDATE geecB_contenuti SET alias='' WHERE id='$id'";
            $geecomDb->eseguiQueryScrittura($query);
            
            if($id>0) {
                header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$id");
            }
            else {
                header("Location: $percorsoGeecomCMS/gestioneContenuti.php?status=400");
            }
            break;
        case 'creaPagina':
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            $titolo            = filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES);
            $metaTitolo        = (isset($_POST["metaTitolo"])) ? filter_input(INPUT_POST,"metaTitolo",FILTER_SANITIZE_ADD_SLASHES) : $titolo;
            $testo             = (isset($_POST["testo"])) ? filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES) : "";
            $stato             = (isset($_POST["stato"]) && $_POST["stato"]=="pubblicato") ? "pubblicato" : "bozza";
            $mostraTitolo      = (isset($_POST["mostraTitolo"]) && $_POST["mostraTitolo"]=="si") ? "si" : "no";
            $attivaBreadcrumbs = (isset($_POST["attivaBreadcrumbs"]) && $_POST["attivaBreadcrumbs"]=="si") ? "si" : "no";
            
            $contenuto->setTitolo($titolo);
            $contenuto->setMetaTitolo($metaTitolo);
            $contenuto->setMostraTitolo($mostraTitolo);
            $contenuto->setAttivaBreadcrumbs($attivaBreadcrumbs);
            $contenuto->setAlias(generaAlias($geecomDb,$titolo));
            $contenuto->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setStato($privato);
            $contenuto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTesto($testo);
            $contenuto->setAutore(filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES));
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $id = $contenuto->crea();

            if($id>0) {
                header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$id");
            }
            else {
                header("Location: $percorsoGeecomCMS/gestioneContenuti.php?status=400");
            }
            break;
        case 'modifica':
            $privato      = (isset($_POST["privato"]) && $_POST["privato"]=="si") ? "si" : "no";
            $stato        = (isset($_POST["stato"]) && $_POST["stato"]=="pubblicato") ? "pubblicato" : "bozza";
            $tipo         = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES);
            $mostraTitolo = (isset($_POST["mostraTitolo"]) && $_POST["mostraTitolo"]=="si") ? "si" : "no";
            $attivaBreadcrumbs = (isset($_POST["attivaBreadcrumbs"]) && $_POST["attivaBreadcrumbs"]=="si") ? "si" : "no";
            if($tipo=="articolo") {
                $attivaBreadcrumbs = "si";
            }
            $mostraNellaHome   = (isset($_POST["mostraNellaHome"]) && $_POST["mostraNellaHome"]=="si") ? "si" : "no";
            $abilitaCommenti   = (isset($_POST["abilitaCommenti"]) && $_POST["abilitaCommenti"]=="si") ? "si" : "no";
            $categoria         = (isset($_POST["categoria"])) ? filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT) : "0";
            $descrizione       = (isset($_POST["descrizione"])) ? filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES) : "";
            $testo             = (isset($_POST["testo"])) ? filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES) : "";
            $arrayCategorie    = (isset($_POST["categorie"])) ? $_POST["categorie"] : array();
            
            if($tipo!="articolo") {
                $dataPubblicazione = date("Y-m-d", strtotime(str_replace("/", "-", filter_input(INPUT_POST, "dataPubblicazione", FILTER_SANITIZE_ADD_SLASHES))));
            }
            else {
                $dataInput         = date("Y-m-d", strtotime(str_replace("/", "-", filter_input(INPUT_POST, "dataPubblicazione", FILTER_SANITIZE_ADD_SLASHES))));
                $oraPubblicazione  = filter_input(INPUT_POST, "oraPubblicazione", FILTER_SANITIZE_ADD_SLASHES);
                $dataPubblicazione = date("Y-m-d H:i", strtotime("$dataInput $oraPubblicazione"));
            }
        
            $contenuto->caricaDatiDalDatabase();
            $contenuto->setTitolo(filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMetaTitolo(filter_input(INPUT_POST,"metaTitolo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMostraTitolo($mostraTitolo);
            $contenuto->setAttivaBreadcrumbs($attivaBreadcrumbs);
            $contenuto->setMostraNellaHome($mostraNellaHome);
            $contenuto->setCommenti($abilitaCommenti);
            $contenuto->setDescrizione($descrizione);
            $contenuto->setAlias(filter_input(INPUT_POST,"alias",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTipo($tipo);
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTesto($testo);
            $contenuto->setStato($stato);
            $contenuto->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setEtichettaImmagine(filter_input(INPUT_POST,"etichettaImmagine",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setCategoria($categoria);
            $contenuto->setDataPubblicazione($dataPubblicazione);
            $contenuto->setCssGenerato($contenuto->cssGenerato());
            $contenuto->setCssAggiuntivo(filter_input(INPUT_POST,"cssAggiuntivo",FILTER_SANITIZE_ADD_SLASHES));
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            
            if($_SESSION["geecomAdmin_ruolo"]=="autore") { // gli autori possono modificare solo i propri contenuti
                if($contenuto->getAutore()==$_SESSION["geecomAdmin_nomeCognome"]) {
                    $contenuto->modifica();

                    aggiungiCategorieArticolo($geecomDb, $arrayCategorie,$contenuto->getId());

                    header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$contenuto->getId()}&status=200");
                }
                else {
                    header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$contenuto->getId()}&status=400");
                }
            }
            else {
                $contenuto->setAutore(filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES)); // solo gli amministratori possono cambiare l'autore
                $contenuto->modifica();

                aggiungiCategorieArticolo($geecomDb, $arrayCategorie,$contenuto->getId());

                header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$contenuto->getId()}&status=200");
            }
            break;
        case 'modificaImmagine':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/articoli", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: $percorsoGeecomCMS/creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }

                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }

                if($impostazioni["generaThumbnail"]=="si") {
                    $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                    $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
                }
            }
    
            $contenuto->modificaFoto($percorsoFoto);
            echo "../$percorsoFoto";
            break;
        case 'modificaImmagineInEvidenzaConPercorso':
            $percorsoFoto = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_ADD_SLASHES);
            $contenuto->modificaFoto($percorsoFoto);
            echo "ok";
            break;
        case 'eliminaImmagineInEvidenza':
            $contenuto->modificaFoto("");
            echo "ok";
            break;
        case 'eliminaImmagineSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaImmagineSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'eliminaVideoSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaVideoSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'eliminaImmagineSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaVideoSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'aggiungiComponentePagina':
            $idPagina     = filter_input(INPUT_GET,'idPagina',FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $tipoElemento = filter_input(INPUT_GET,'tipoElemento',FILTER_SANITIZE_ADD_SLASHES);
            
            //recupero l'ultima posizione occupata nel pannello laterale
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryUltimaPosizione = "SELECT posizione FROM geecB_composizionePagine WHERE idPagina=$idPagina AND tipoElemento LIKE '$tipoElemento' ORDER BY posizione DESC LIMIT 1";
            $risPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            $ultimaPosizione = $risPosizione->fetch_assoc();
            $posizione = $ultimaPosizione["posizione"]+1;
            
            $idElemento = creaComponente($geecomDb,$idComponente, $idPagina);
            
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $geecomDb->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idPagina,'$tipoElemento',$idElemento,$posizione,'$idSezione')";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            
            if($tipoElemento=="contenuto") {
                header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$idPagina&status=350");
            }
            else if($tipoElemento=="elementoPortfolio") {
                header("Location: $percorsoGeecomCMS/componenti/portfolio/creaElemento.php?id=$idPagina&status=350");
            }
            else if($tipoElemento=="evento") {
                header("Location: $percorsoGeecomCMS/componenti/eventi/creaEvento.php?id=$idPagina&status=350");
            }
            break;
        case 'modificaComponente':
            $id = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_POST, "idComponente", FILTER_SANITIZE_NUMBER_INT);
            $datiComponente = $geecomDb->leggiSingolaRiga("geecB_composizionePagine", $id); // recupero i dati sul componente, perché ci sono componenti che necessitano di azioni particolari

            $classeSezione = filter_input(INPUT_POST, "classeSezione", FILTER_SANITIZE_ADD_SLASHES);
            $modificaTesto = "testo='".$geecomDb->escapeString($_POST['testo'])."',";

            $animazione   = (isset($_POST['animazione'])) ? filter_input(INPUT_POST, "animazione", FILTER_SANITIZE_ADD_SLASHES) : "";
            $altreOpzioni = (isset($_POST['opzioneClasseColonne'])) ? "opzioneClasseColonne=".filter_input(INPUT_POST, "opzioneClasseColonne", FILTER_SANITIZE_ADD_SLASHES).";" : "";
            if(isset($_POST["opzioneTagH"])) {
                $altreOpzioni .= "opzioneTagH=".filter_input(INPUT_POST, "opzioneTagH", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneSeparatore"])) {
                $altreOpzioni .= "opzioneSeparatore=".filter_input(INPUT_POST, "opzioneSeparatore", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneAllineamento"])) {
                $altreOpzioni .= "opzioneAllineamento=".filter_input(INPUT_POST, "opzioneAllineamento", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneDimensioniIcona"])) {
                $altreOpzioni .= "opzioneDimensioniIcona=".filter_input(INPUT_POST, "opzioneDimensioniIcona", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneStile"])) {
                $altreOpzioni .= "opzioneStile=".filter_input(INPUT_POST, "opzioneStile", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["tagAlt"])) {
                $altreOpzioni .= "tagAlt=".filter_input(INPUT_POST, "tagAlt", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            
            // questo codice serve per modificare la didascalia dell'immagine
            if($idComponente==17) {
                $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                $immagine->caricaDatiDalDatabase();
                $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
                $immagine->modifica();
            }

            if(isset($_FILES['file'])) {
                // a seconda che si tratti del componente audio o del componente immagine 
                // viene creato il percorsoBase e vengono definiti i tipi di file ammessi
                if($idComponente==17) { // componente immagine
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $percorsoBase = "immagini/altro/";
                }
                else if($idComponente==36) { // componente Singola risorsa
                    $tipiFileAmmessi = array("text/plain","application/pdf","application/msword","application/vnd.oasis.opendocument.text","","image/png","image/jpeg","image/webp","image/gif");
                    $percorsoBase = "file/risorse/";
                }
                else {
                    $tipiFileAmmessi = array("audio/mpeg","application/ogg");
                    $percorsoBase = "file/audio/";
                }

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $modificaTesto ="testo='$percorsoFile', ";

                        if($idComponente==17) { // se è il componente immagine
                            $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                            $immagine->caricaDatiDalDatabase();
                            $immagine->setPercorso($percorsoFile);
                            $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
                            $immagine->modifica();

                            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                                }
                            }
                        }
                        
                        if($idComponente==36) { // se il componente è risorsa singola devo aggiornare anche la risorsa 
                            $nomeRisorsa = filter_input(INPUT_POST, "nomeRisorsa", FILTER_SANITIZE_ADD_SLASHES);

                            $queryModificaRisorsa = "UPDATE geecB_risorse SET percorso='$percorsoFile', nome='$nomeRisorsa' WHERE id={$datiComponente["idElemento"]}";
                            $geecomDb->eseguiQueryScrittura($queryModificaRisorsa);
                        }
                    }
                    else {
                        $modificaTesto = "";
                    }
                }
            }
            
            //aggiorno le impostazioni con i dati passati in input
            if($idComponente==36) {
                $nomeRisorsa = filter_input(INPUT_POST, "nomeRisorsa", FILTER_SANITIZE_ADD_SLASHES);
                $altreOpzioni.="nomeRisorsa=$nomeRisorsa;";
                
                $percorso ="$percorsoBase/".str_replace(array("'","\""),"",$_FILES['file']['name']);
                $queryModificaRisorsa = "UPDATE geecB_risorse SET nome='$nomeRisorsa' WHERE id={$datiComponente["idElemento"]}";
                $geecomDb->eseguiQueryScrittura($queryModificaRisorsa);
            }
            
            $queryAggiornamentoProdotto = "UPDATE geecB_composizionePagine SET $modificaTesto animazione='$animazione', altreOpzioni='$altreOpzioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            
            if($datiComponente["tipoElemento"]=="contenuto" || $datiComponente["tipoElemento"]=="contenutoSezione") {
                header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$datiComponente["idPagina"]}&status=355");
            }
            else if($datiComponente["tipoElemento"]=="elementoPortfolio") {
                header("Location: $percorsoGeecomCMS/componenti/portfolio/creaElemento.php?id={$datiComponente["idPagina"]}&status=355");
            }
            else if($datiComponente["tipoElemento"]=="evento") {
                header("Location: $percorsoGeecomCMS/componenti/eventi/creaEvento.php?id={$datiComponente["idPagina"]}&status=355");
            }
            else if($datiComponente["tipoElemento"]=="categoriaSopraArticoli" || $datiComponente["tipoElemento"]=="categoriaSottoArticoli") {
                header("Location: $percorsoGeecomCMS/creaCategoria.php?id={$datiComponente["idPagina"]}&status=355");
            }
            break;
        case 'aggiungiComponenteSezione':
            $idPagina                       = filter_input(INPUT_GET,'idPagina',FILTER_SANITIZE_NUMBER_INT);
            $tabellaSezione                 = filter_input(INPUT_GET,'tabellaSezione',FILTER_SANITIZE_ADD_SLASHES);
            $idSezioneNuovoElemento         = filter_input(INPUT_GET,'idSezioneNuovoElemento',FILTER_SANITIZE_NUMBER_INT);
            $posizioneNuovoElementoSezione  = filter_input(INPUT_GET,'posizioneNuovoElementoSezione',FILTER_SANITIZE_NUMBER_INT);
            $idComponente                   = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            $idElemento = creaComponente($geecomDb,$idComponente, $idPagina);
            
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $geecomDb->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idPagina,'contenutoSezione',$idElemento,0,'$idSezione')";
            $idComponenteSezione = $geecomDb->eseguiQueryCreazione($queryAggiornamentoProdotto);
            
            $queryAggiornamentoSezione = "UPDATE $tabellaSezione SET idComponenteSezione$posizioneNuovoElementoSezione = $idComponenteSezione WHERE id=$idSezioneNuovoElemento";
            $geecomDb->eseguiQueryCreazione($queryAggiornamentoSezione);
            
            header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$idPagina&status=350");
            break;
        case 'modificaOpzioniSezione':
            $id             = filter_input(INPUT_POST,'idSezioneDaModificare',FILTER_SANITIZE_NUMBER_INT);
            $idSezione      = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_ADD_SLASHES);
            $classeSezione  = filter_input(INPUT_POST,'classeSezione',FILTER_SANITIZE_ADD_SLASHES);
            $margineSezione = filter_input(INPUT_POST,'margineSezione',FILTER_SANITIZE_ADD_SLASHES);
            $paddingSezione = filter_input(INPUT_POST,'paddingSezione',FILTER_SANITIZE_ADD_SLASHES);
            $aTuttaLarghezza= filter_input(INPUT_POST,'sezioneATuttaLarghezza',FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo   = filter_input(INPUT_POST,'coloreSfondo',FILTER_SANITIZE_ADD_SLASHES);
            
            if(isset($_FILES['file'])) {

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/altro/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                            }
                        }
                    }
                    else {
                        $percorsoFile = "";
                    }
                }
            }
            
            if(isset($_FILES['video'])) {
                if($_FILES['video']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $percorsoFileVideo ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("video/mp4","video/ogg","video/webm");
                    $gestoreUpload = new GestoreUpload("video", $tipiFileAmmessi, 8, "../file/video/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFileVideo  = str_replace("../","",$esitoUpload["percorso"]);
                    }
                    else {
                        $percorsoFileVideo = "";
                    }
                }
            }
            
            $contenuto->modificaOpzioniSezioneComponente($id, $idSezione, $classeSezione, $aTuttaLarghezza, $margineSezione, $paddingSezione,$coloreSfondo,$percorsoFile,$percorsoFileVideo);
            $contenuto->aggiornaCssGenerato();

            if($contenuto->getTipo()=="elementoPortfolio") {
                header("Location: $percorsoGeecomCMS/componenti/portfolio/creaElemento.php?id={$contenuto->getId()}&status=360");
            }
            else {
                header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$contenuto->getId()}&status=360");
            }
            break;
        case 'cambiaIdElemento':
            $id         = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idElemento = filter_input(INPUT_GET,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $query = "UPDATE geecB_composizionePagine SET idElemento=$idElemento WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'modificaPosizioneComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $posizione    = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);
            
            $contenuto->caricaDatiDalDatabase();
            $contenuto->modificaPosizioneComponente($idComponente,$posizione);
            echo "ok";
            break;
        case 'modificaPosizioneImmagine':
            $idImmagine  = filter_input(INPUT_POST,'idImmagine',FILTER_SANITIZE_NUMBER_INT);
            $posizione   = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);
            
            $contenuto->caricaDatiDalDatabase();
            $contenuto->modificaPosizioneImmagine($idImmagine,$posizione);
            echo "ok";
            break;
        case 'duplicaComponente':
            $contenuto->caricaDatiDalDatabase();
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $contenuto->duplicaComponente($idComponente);
            $contenuto->aggiornaCssGenerato();
            
            $query    = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            $datiComponente = $risQuery->fetch_assoc();
            
            if($datiComponente["tipo"]=="componenteDinamico" || $datiComponente["tipo"]=="componenteStrutturaPagina") { // in questo caso il messaggio deve essere ricaricata la pagina creaContenuto.php per generare le modal
                echo "ok,ricarica";
            }
            else {
                echo "ok";
            }
            break;
        case 'cambiaDatiSezioneMultipla':
            $tabella      = filter_input(INPUT_POST,'tabella',FILTER_SANITIZE_ADD_SLASHES);
            $idSezione    = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_NUMBER_INT);
            $proporzioni  = filter_input(INPUT_POST,'proporzioni',FILTER_SANITIZE_ADD_SLASHES);
            $allineamento = filter_input(INPUT_POST,'allineamento',FILTER_SANITIZE_ADD_SLASHES);
            $contenuto->cambiaDatiSezioneMultipla($tabella,$idSezione,$proporzioni,$allineamento);
            echo "ok";
            break;
        case 'stampaComponentiContenuto':
            $contenuto->caricaDatiDalDatabase();
            
            $percorsoBase = ($contenuto->getTipo()=="elementoPortfolio") ? "../../" : ""; 
            $contenuto->stampaComponentiContenuto($percorsoBase);
            break;
        case 'stampaBoxTraduzioni':
            $contenuto->caricaDatiDalDatabase();
            $contenuto->stampaBoxTraduzioni();
            break;
        case 'eliminaComponente':
            $id = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $geecomDb->eseguiQueryCancellazione("geecB_composizionePagine", $id);
            echo "ok";
            break;
        case 'eliminaComponenteSezione':
            $id                = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idSezione         = filter_input(INPUT_GET,'idSezione',FILTER_SANITIZE_NUMBER_INT);
            $posizioneElemento = filter_input(INPUT_GET,'posizioneElemento',FILTER_SANITIZE_NUMBER_INT);
            $tabellaSezione    = filter_input(INPUT_GET,'tabellaSezione',FILTER_SANITIZE_ADD_SLASHES);
            
            // elimino l'occorrenza
            $geecomDb->eseguiQueryCancellazione("geecB_composizionePagine", $id);
            
            // metto a 0 il valore nella tabella di sezione
            $query = "UPDATE $tabellaSezione SET idComponenteSezione$posizioneElemento = 0 WHERE id=$idSezione";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'duplica':
            $idContenutoDuplicato = $contenuto->duplica();
            header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$idContenutoDuplicato&status=310");
            break;
        case 'traduci':
            $lingua = filter_input(INPUT_GET, "lingua",FILTER_SANITIZE_ADD_SLASHES);
            $idContenutoTradotto = $contenuto->traduci($lingua);
            header("Location: $percorsoGeecomCMS/creaContenuto.php?id=$idContenutoTradotto&status=310");
            break;
        case 'eliminaAssociazioneTagArticoli':
            $idTag = filter_input(INPUT_POST, "idTag",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaAssociazioneTagArticolo($idTag);
            echo "ok";
            break;
        case 'associaArticoloAlTag':
            $idTag = filter_input(INPUT_POST,"idTag",FILTER_SANITIZE_NUMBER_INT);
            $queryTagEsistenti = "SELECT * FROM geecB_associazioniTagArticoli WHERE idArticolo = {$contenuto->getId()} AND idTag = $idTag";
            $risTagEsistenti   = $geecomDb->eseguiQueryLettura($queryTagEsistenti);
            if($risTagEsistenti->num_rows == 0) {
                $contenuto->creaAssociazioneTagArticolo($idTag);
                $tag = $geecomDb->leggiSingolaRiga("geec_tag", $idTag);
                echo"<div id=\"divTag{$idTag}\" class=\"d-inline-block mr-2 mb-2\">
                        <button type=\"button\" class=\"btn btn-primary btn-sm round\" onclick=\"eliminaAssociazioneTagArticolo({$idTag})\">{$tag["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                    </div>";                
            }
            else {
                echo "L'articolo è già associato a questo tag";
            }
            break;
        case 'associaArticoloAPiuTag':
            $arrayTag = $_POST["tagDaAggiungere"];
            
            foreach($arrayTag as $idTag) {
                $contenuto->creaAssociazioneTagArticolo($idTag);
            }
            header("Location: $percorsoGeecomCMS/creaContenuto.php?id={$contenuto->getId()}");
            break;
        case 'elimina':
            if($_SESSION["geecomAdmin_ruolo"]=="autore") { // gli autori possono eliminare solo i propri contenuti
                $contenuto->caricaDatiDalDatabase();
                if($contenuto->getAutore()==$_SESSION["geecomAdmin_nomeCognome"]) {
                    $contenuto->elimina();
                    echo "ok";
                }
                else {
                    echo "Non è possibile rimuvere un contenuto di un altro autore";
                }
            }
            else {
                $contenuto->elimina();
                echo "ok";
            }
            break;
        case 'creaElementoPortfolio':
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            $idPortfolio       = filter_input(INPUT_POST,"idPortfolio",FILTER_SANITIZE_NUMBER_INT);
            $titolo            = filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES);
            $linguaElemento    = recuperaLinguaElemento($geecomDb,$idPortfolio);
            
            $queryUltimaPosizione = "SELECT posizione FROM geecB_contenuti WHERE contenutoRiferimento=$idPortfolio ORDER BY posizione DESC LIMIT 1";
            $resultPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            if($resultPosizione->num_rows==0) { //la tabella è vuota
                $posizione=1;
            }
            else {
                $risPosizione = $resultPosizione->fetch_array(MYSQLI_NUM);
                $posizione = $risPosizione[0]+1;
            }
            
            $contenuto->setContenutoRiferimento($idPortfolio);
            $contenuto->setTitolo($titolo);
            $contenuto->setMetaTitolo($titolo);
            $contenuto->setAlias(generaAlias($geecomDb,$titolo));
            $contenuto->setMostraTitolo("si");
            $contenuto->setLingua($linguaElemento);
            $contenuto->setTipo("elementoPortfolio");
            $contenuto->setMostraNellaHome("si");
            $contenuto->setCommenti("no");
            $contenuto->setStato("pubblicato");
            $contenuto->setPunteggioSeo("scadente");
            $contenuto->setTemplate("temaElementoPortfolioGalleriaImmagini-8-4.php");
            $contenuto->setAttivaBreadcrumbs("no");
            $contenuto->setPosizione($posizione);
            $contenuto->setCategoria(0);
            $contenuto->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $id = $contenuto->crea();
            
            if($id>0) {
                echo "ok";
            }
            break;
        case 'aggiungiImmaginiElementoPortfolio':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_NUMBER_INT);
                
            $queryUltimaPosizione = "SELECT posizione FROM geec_immagini WHERE idContenuto=$idElemento AND tipoImmagine LIKE 'immagineElementoPortfolio' ORDER BY posizione DESC LIMIT 1";
            $resultPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            if($resultPosizione->num_rows==0) { //la tabella è vuota
                $posizioneImmagine=1;
            }
            else {
                $risPosizione = $resultPosizione->fetch_array(MYSQLI_NUM);
                $posizioneImmagine = $risPosizione[0]+1;
            }
            
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/portfolio", 0, $contenuto->getTitolo());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, $idElemento, 'immagineElementoPortfolio', '$percorsoFoto','','$posizioneImmagine')";
                    $geecomDb->eseguiQueryScrittura($queryCreaImmagine);
                    
                    // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                    if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                        $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                        if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                            $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                        }
                    }
                }
            }
            else {
                foreach($esitoUpload["elencoRisultati"] as $risultato) {
                    if($risultato["percorso"]!="") {
                        $percorsoFoto = str_replace("../","",$risultato["percorso"]);
                        $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, $idElemento, 'immagineElementoPortfolio', '$percorsoFoto','','$posizioneImmagine')";
                        $geecomDb->eseguiQueryScrittura($queryCreaImmagine);
                        $posizioneImmagine++;
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($risultato["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $risultato["percorso"]);
                            }
                        }
                    }
                }
            }
            break;
        case 'aggiungiImmaginiGalleria':
                
            $queryUltimaPosizione = "SELECT posizione FROM geec_immagini WHERE idContenuto={$contenuto->getId()} AND tipoImmagine LIKE 'immagineGalleria' ORDER BY posizione DESC LIMIT 1";
            $resultPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            if($resultPosizione->num_rows==0) { //la tabella è vuota
                $posizioneImmagine=1;
            }
            else {
                $risPosizione = $resultPosizione->fetch_array(MYSQLI_NUM);
                $posizioneImmagine = $risPosizione[0]+1;
            }
            
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/gallerie", 0, $contenuto->getTitolo());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, {$contenuto->getId()}, 'immagineGalleria', '$percorsoFoto','','$posizioneImmagine')";
                    $geecomDb->eseguiQueryScrittura($queryCreaImmagine);
                    
                    // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                    if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                        $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                        if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                            $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                        }
                    }
                }
            }
            else {
                foreach($esitoUpload["elencoRisultati"] as $risultato) {
                    if($risultato["percorso"]!="") {
                        $percorsoFoto = str_replace("../","",$risultato["percorso"]);
                        $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, {$contenuto->getId}, 'immagineGalleria', '$percorsoFoto','','$posizioneImmagine')";
                        $geecomDb->eseguiQueryScrittura($queryCreaImmagine);
                        $posizioneImmagine++;
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($risultato["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $risultato["percorso"]);
                            }
                        }
                    }
                }
            }
            break;
        case 'stampaElencoImmagini':
            $contenuto->caricaDatiDalDatabase();
            $percorsoBase = ($contenuto->getTipo()=="elementoPortfolio") ? "../../" : "../"; 
            $contenuto->stampaImmaginiContenuto($percorsoBase);
            break;
        case 'invertiStato':
            $contenuto->caricaDatiDalDatabase();
            if($contenuto->invertiStato()=="pubblicato") {
                echo"text-success";
            }
            else {
                echo"text-black-50";
            }
            break;
        case 'invertiValoreNascosto':
            $valoreNascostoAttuale = $contenuto->invertiValoreNascostoPerUnComponente(filter_input(INPUT_POST,"idComponente",FILTER_SANITIZE_NUMBER_INT));
            if($valoreNascostoAttuale=="si") {
                echo"Il componente ora non è visibile";
            }
            else {
                echo"Il componente è ora visibile";
            }
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecB_componenti",$idComponente);
        
        if(($datiComponente["tipo"]=="componenteDinamicoPagine" || $datiComponente["tipo"]=="componenteStrutturaPagina") && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina       = $geecomDb->leggiSingolaRiga("geecB_contenuti",$idPagina);
            $nomeComponente   = $geecomDb->escapeString($datiComponente["nome"]);
            $titoloEscape     = str_replace(array("'","\""),"",$datiPagina["titolo"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente pagina $titoloEscape')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else if($datiComponente["nome"]=="Singola risorsa") {
            $datiContenuto  = $geecomDb->leggiSingolaRiga("geecB_contenuti",$idPagina);
            $nomeComponente = filter_var("File ".$datiContenuto["titolo"],FILTER_SANITIZE_ADD_SLASHES);
            $fileScaricabile = new FileScaricabile($geecomDb, 0, $nomeComponente);

            return $fileScaricabile->crea();
        }
        else {
            return 0;
        }
    }
    
    function aggiungiCategorieArticolo($geecomDb, $categorieAssociate,$idContenuto) {
        $queryEliminazioneOccorrenzePregresse ="DELETE FROM geec_associazioneCategorieContenuti WHERE idContenuto=$idContenuto AND tipoContenuto='articolo'";
        $geecomDb->eseguiQueryScrittura($queryEliminazioneOccorrenzePregresse);
        
        foreach($categorieAssociate as $categoriaAssociata) {
            $queryAssociazioneCategoria ="INSERT INTO geec_associazioneCategorieContenuti VALUES($categoriaAssociata,$idContenuto,'articolo');";
            $geecomDb->eseguiQueryScrittura($queryAssociazioneCategoria);
        }
    }
    
    function recuperaLinguaElemento($geecomDb,$idPortfolio) {
        $datiPortfolio = $geecomDb->leggiSingolaRiga("geec_portfolio",$idPortfolio);
        
        if($datiPortfolio["traduzioneItaliano"]==0) {
            return "italiano";
        }
        else if($datiPortfolio["traduzioneInglese"]==0) {
            return "inglese";
        }
        else if($datiPortfolio["traduzioneTedesco"]==0) {
            return "tedesco";
        }
        else if($datiPortfolio["traduzioneFrancese"]==0) {
            return "francese";
        }
        else if($datiPortfolio["traduzioneSpagnolo"]==0) {
            return "spagnolo";
        }
        else { // se non è stata specificata una lingua per il portfolio i suoi elementi vengono impostati in italiano
            return "italiano";              
        }
    }
